import stanford.karel.*;

public class PaintByNumbers extends SuperKarel {
	
	public void run() {
		paintRow();
		for(int i = 0; i < 8; i++) {
		    changeRow();
		    paintRow();
		}
	}
	
	// paint a single row
	// pre: karel is at the start of the row
	// post: karel is at the end of the row
	private void paintRow() {
	    paintCorner();
	    while(frontIsClear()) {
	        move();
	        paintCorner();
	    }
	}
	
	// paint a single corner
	// pre: the corner has beepers, is not painted
	// post: the corner has no beepers, is painted
	private void paintCorner() {
	    if(beepersPresent()) {
	        pickBeeper();
	        if(beepersPresent()) {
	            pickBeeper();
	            paintCorner(BLACK);
	        } else {
	            paintCorner(BLUE);
	        }
	    } else {
	        paintCorner(WHITE);
	    }
	}
	
	// move to the east of the next row
	// pre: karel is facing east at the end of a row
	// post: kare is facing east at the start of one row up
	private void changeRow() {
	    turnAround();
	    moveToWall();
	    turnRight();
	    move();
	    turnRight();
	}
	
	private void moveToWall() {
	    while(frontIsClear()) {
	        move();
	    }
	}

}

